//
//  SCLogger.h
//
//  Created by Rico on 3/1/11.
//  Copyright 2011 Kitestack Software. All rights reserved.
//

/*
 Basic logging support.
 
 To configure the level, add the "SCConfigLogLevel" key to Info.plist.
 
 To keep n log messages in memory, use the "SCConfigMessageBacklogSize" key in the Info.plist.

*/

#import <Cocoa/Cocoa.h>

#define Error(format, ...) \
[[SCLogger sharedInstance] log: [NSString stringWithFormat:(format), ##__VA_ARGS__] \
                        atLevel: kSCErrorLogLevel \
                         inFile: [NSString stringWithCString: __FILE__ encoding: NSUTF8StringEncoding] \
                     inFunction: [NSString stringWithCString: __FUNCTION__ encoding: NSUTF8StringEncoding] \
                         atLine: [NSNumber numberWithInt: __LINE__]];


#define Warning(format, ...) \
[[SCLogger sharedInstance] log: [NSString stringWithFormat:(format), ##__VA_ARGS__] \
                        atLevel: kSCWarningLogLevel \
                         inFile: [NSString stringWithCString: __BASE_FILE__ encoding: NSUTF8StringEncoding] \
                     inFunction: [NSString stringWithCString: __FUNCTION__  encoding: NSUTF8StringEncoding] \
                         atLine: [NSNumber numberWithInt: __LINE__]];


#define Info(format, ...) \
[[SCLogger sharedInstance] log: [NSString stringWithFormat:(format), ##__VA_ARGS__] \
                        atLevel: kSCInfoLogLevel \
                         inFile: [NSString stringWithCString: __FILE__ encoding: NSUTF8StringEncoding] \
                     inFunction: [NSString stringWithCString: __FUNCTION__ encoding: NSUTF8StringEncoding] \
                         atLine: [NSNumber numberWithInt: __LINE__]];

#define Debug(format, ...) \
[[SCLogger sharedInstance] log: [NSString stringWithFormat:(format), ##__VA_ARGS__] \
                        atLevel: kSCDebugLogLevel \
                         inFile: [NSString stringWithCString: __FILE__ encoding: NSUTF8StringEncoding] \
                     inFunction: [NSString stringWithCString: __FUNCTION__ encoding: NSUTF8StringEncoding] \
                         atLine: [NSNumber numberWithInt: __LINE__]];

extern NSString* const kSCConfigLogLevel;
extern NSString* const kSCConfigMessageBacklogSize;
extern NSString* const kSCDebugLoggingEnabled;

typedef enum _SCLogLevel {
    
    kSCErrorLogLevel   = 0,
    kSCWarningLogLevel = 1,
    kSCInfoLogLevel    = 2,
    kSCDebugLogLevel   = 3,   
    
} SCLogLevel;

@interface SCLogger : NSObject {
    
    SCLogLevel maxLogLevel;
    
    NSInteger _messageBacklogSize;
    
    NSMutableArray *_messageBacklog;
    
    NSFileHandle *_logFileHandle;
    
    SCLogLevel _logFileMaxLevel;
}
@property (strong) NSMutableArray *messageBacklog;
@property (strong) NSFileHandle *logFileHandle;
@property(readwrite, assign) SCLogLevel maxLogLevel;
@property (assign) NSInteger messageBacklogSize;

+ (SCLogger*)sharedInstance;

- (void) log: (NSString*) message atLevel: (SCLogLevel) logLevel inFile: (NSString*) file inFunction: (NSString*) function atLine: (NSNumber*) line;

- (void)logToFile:(NSString*)filePath atLevel:(SCLogLevel)logLevel;

@end
